/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.property;

import java.util.Set;
import net.ilexiconn.llibrary.server.property.IStringProperty;

public interface IStringSelectionProperty
extends IStringProperty {
    @Override
    default public boolean isValidString(String value) {
        Set<String> validStringValues = this.getValidStringValues();
        return validStringValues == null || validStringValues.contains(value);
    }

    public Set<String> getValidStringValues();

    public static class WithState
    extends IStringProperty.WithState
    implements IStringSelectionProperty {
        private final Set<String> validValues;

        public WithState(String value) {
            this(value, null);
        }

        public WithState(String value, Set<String> validValues) {
            super(value);
            this.validValues = validValues;
        }

        @Override
        public Set<String> getValidStringValues() {
            return this.validValues;
        }
    }
}

